﻿using System;
using System.Collections.Generic;
using Demo.Linq;

namespace LINQDemo
{
    class Program8
    {
        /// <summary>
        /// .NET 3.0 - lambda expressions
        /// </summary>
        /// <param name="args"></param>
        static void Main(string[] args)
        {
            IEnumerable<Person> tmpResults =
                Enumerable.Where(Person.GetPersons(),                           
                                //new MyFunc<Person, bool>(Helper.MyPredicate) 
                                p => p.Age > 30
                                );

            IEnumerable<TempType> results =
                Enumerable.Select(tmpResults,                                   
                                //new MyFunc<Person, TempType>(Helper.MySelector)
                                p => 
                                {
                                    TempType t = new TempType();
                                    t.Name = p.Name;
                                    t.Age = p.Age;
                                    return t;
                                }
                                );

            foreach (TempType p in results)
            {
                //p.
                Console.WriteLine(p.ToString());
            }

            Console.ReadLine();
        }
    }
}
